/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support 
 * ----------------------------------------------------------------------------
 * Copyright (c) 2008, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

#ifndef ISO7816_4_H
#define ISO7816_4_H

//------------------------------------------------------------------------------
// Types and Constants Definition
//------------------------------------------------------------------------------

// Coding of instruction byte (INS)
#define ERASE_BINARY                    0x0E
#define VERIFY                          0x20
#define MANAGE_CHANNEL                  0x70
#define EXTERNAL_AUTHENTICATE           0x82
#define GET_CHALLENGE                   0x84
#define INTERNAL_AUTHENTICATE           0x88
#define SELECT_FILE                     0xA4
#define READ_BINARY                     0xB0
#define READ_RECORD                     0xB2
#define GET_RESPONSE                    0xC0
#define ENVELOPE                        0xC2
#define GET_DATA                        0xCA
#define WRITE_BINARY                    0xD0
#define WRITE_RECORD                    0xD2
#define UPDATE_BINARY                   0xD6
#define PUT_DATA                        0xDA
#define UPDATE_RECORD                   0xDC
#define APPEND_RECORD                   0xE2

// manage chanel
#define OPEN_CHANNEL                    0x00
#define CLOSE_CHANNEL                   0x80

// Coding of status bytes (SW1-SW2) for normal processing (Process completed)
#define NORMAL_PROCESSING               0x0090

// Coding of status bytes (SW1-SW2) for warning processing (Process completed)
#define WARNING_EE_UNCHANGED            0x0062
#define WARNING_EE_CHANGED              0x0063

// Coding of status bytes (SW1-SW2) for execution error (Process aborted)
#define EXEC_ERR_EE_UNCHANGED           0x0064
#define EXEC_ERR_EE_CHANGED             0x0065
#define EXEC_ERR_RESERVED               0x0066

// Coding of status bytes (SW1-SW2) for checking error (Process aborted)
#define CHK_ERR_WRONG_P3                0x0067
#define CHK_ERR_WRONG_CLA_FNCT          0x0068
#define CHK_ERR_CMDE_NOT_ALLOWED        0x0069
#define CHK_ERR_WRONG_PARAMETER         0x006A
#define CHK_ERR_WRONG_P1_P2             0x006B
#define CHK_ERR_WRONG_LENGTH            0x006C
#define CHK_ERR_INS_NOT_SUPPORTED       0x006D
#define CHK_ERR_CLA_NOT_SUPPORTED       0x006E
#define CHK_ERR_NO_DIAGNOSIS            0x006F

// Coding of SW2 when SW1 is 0x65
#define MEMORY_FAILURE                  0x81

// Coding of SW2 when SW1 is 0x69
#define AUTHENTICATE_NOT_STATISFIED     0x83
#define CONDITIONS_NOT_STATISFIED       0x85

// Coding of SW2 when SW1 is 0x6A
#define LC_INCONSISTENT_WITH_P1P2       0x87

// Coding of class byte (CLA)
#define CLASS_7816_4                    0x00

//------------------------------------------------------------------------------
// General ISO 7813-4 Header
//------------------------------------------------------------------------------
typedef struct {

   unsigned char Cla;       // Instruction class
   unsigned char Ins;       // Instruction code
   unsigned char msbP1P2;   // reference
   unsigned char lsbP1P2;   // reference
   unsigned char P3;        // number of data bytes

} S_iso_7813_to_header;

//------------------------------------------------------------------------------
// Verify structure is paked after the Header at the odd address
//------------------------------------------------------------------------------
typedef struct {

   unsigned char msb_add;       // Big endian address
   unsigned char lsb_add;       //
   unsigned char msb_Size;      // Big endian zize
   unsigned char lsb_Size;
   unsigned char hsb_Checksum;  // Big endian Checksum
   unsigned char MHsb_Checksum; // Middel high
   unsigned char MLsb_Checksum; // Middel low
   unsigned char lsb_Checksum;  // Low bytes

} S_iso_7816_verify;

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
extern void ISO7816_Init( const Pin pPinIso7816RstMC );
extern void ISO7816_IccPowerOff(void);
extern unsigned short ISO7816_XfrBlockTPDU_T0(const unsigned char *pAPDU, 
                                        unsigned char *pMessage, 
                                        unsigned short wLength );
extern void ISO7816_Escape( void );
extern void ISO7816_RestartClock(void);
extern void ISO7816_StopClock( void );
extern void ISO7816_toAPDU( void );
extern void ISO7816_Datablock_ATR( unsigned char* Atr, unsigned char* length );
extern void ISO7816_SetDataRateandClockFrequency( unsigned int dwClockFrequency, unsigned int dwDataRate );
extern unsigned char ISO7816_StatusReset( void );
extern void ISO7816_cold_reset( void );
extern void ISO7816_warm_reset( void );
extern void ISO7816_Decode_ATR( unsigned char* atr );

#endif // ISO7816_4_H

